<?php

/*
	DevSaver web framework
	copyright (c) 2013-2016 DevSaver
		web:  www.devsaver.com
		mail: support@devsaver.com

*/
class CVars {
	var $database;
	var $table;
	var $data = array();
	var $modif = FALSE;


	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $ignore_vars = array(
		"retrunurl",
		"show_settings"
	);
	

	function __construct($database,$table) {
		//$this->database = (is_object($database)) ? &$database : new CDatabase($database);
		if (is_object($database))
			$this->database = &$database;
		else
			$this->database = new CDatabase($database);

		$this->table = $table;

		return $this->Autoload();
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Search($query = "") {
		$vars = $this->database->QFetchRowArray("SELECT * FROM `{$this->table}` " . ($query ? " WHERE " . $query : "" ) );

		return $this->ProcessVars($vars);
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ExtractVals($keys , $vars) {
		if (is_array($keys)) {
			foreach ($keys as $key => $val) {

				$data[$val] = $vars[$val];
			}

			return $data;			
		}
		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AutoLoad() {
		$vars = $this->database->QFetchRowArray("SELECT * FROM `{$this->table}` "); //WHERE autoload=1

		$this->data = $this->ProcessVars($vars);		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessVars($data) {

		if (is_array($data)) {
			foreach ($data as $key => $val) {
				$vars[$val["name"]] = $val["value"] ? $val["value"] : $val["default_value"];
			}			
		}		

		return $vars;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetVars($keys) {
		if (is_array($keys)) {
			
			$vars = $this->database->QFetchRowArray("SELECT * FROM `{$this->table}` WHERE name in ('" . implode("','" , $keys ) . "')");

			return $this->ProcessVars($vars);
		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetVar($key) {
		$vars = $this->GetVars(array($key));

		$results = $this->processVars($vars);

		return $results[$key];
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetVar($key , $val) {

		if ($this->ignore_vars[$key]) {
			return false;
		}
	

		//$key = $this->database->escape_string($key);
		//$val = $this->database->escape_string($val);

		 if (is_array($this->database->QFetchArray("SELECT * from {$this->table} WHERE `name` LIKE '{$key}'"))) {
			 $this->database->QueryUpdate(
				 $this->table,
				 array(
					"name"	=> $key,
					"value"	=> $val
				 ),
				 "name LIKE '{$key}'"
			);
		 } else {
			 $this->database->QueryInsert(
				 $this->table,
				 array(
					"name"	=> $key,
					"value"	=> $val
				 )
			);
		 }

/*


		$this->database->Query(
			"INSERT INTO {$this->table} (`name` , `value`) " . 
			"VALUES  ('%s' , '%s') ON DUPLICATE KEY UPDATE `value`='%s'",
			array(
				$key , 
				$val, 
				$val
			)
		);		
*/
		return true;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DelVar($key) {
		 $this->database->Query("DELETE FROM {$this->table} WHERE `name` LIKE '{$key}'");
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DelVars($vars) {

		if (is_array($vars)) {
			foreach ($vars as $key => $val) {
				$this->DelVar($val);
			}
			
		}
		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetVars($vars) {
		
		if (is_array($vars)) {
			foreach ($vars as $key => $val) {

				$this->SetVar($key , $val );

				$this->data[$key] = $val;
			}			
		}

		return true;		
	}

	
	
	

	//deprecated
	function Load() {
		global $_USER;
		$vars = $this->database->QFetchRowArray("SELECT * FROM `$this->table`");

		if (is_array($vars))
			foreach ($vars as $key => $var) {

				if (strtolower($var["name"]) != "retrunurl") {
					if (isset($var["base_user"]) && ($var["base_user"] != $_USER["user_id"])) {
						unset($vars[$key]);
					} else				
						$this->data[$var["name"]] = stripslashes($var["value"]);
				}			
			}
	}

	function __SetAll($var) {
		$this->data = array_merge ((array)$this->data ,$var);
		$this->modif = TRUE;
	}
	

	function Set($name,$value,$force = FALSE) {

		$value = addslashes($value);
		 if ($force == TRUE) {


			 if (is_array($this->database->QFetchArray("SELECT * from {$this->table} WHERE `name` LIKE '{$name}'"))) {
				 $this->database->Query("UPDATE `$this->table` SET `value` = '$value' WHERE (`name` = '$name')");
			 } else {
				 $this->database->QueryInsert(
					 $this->table,
					 array(
						"name"	=> $name,
						"value"	=> $value
					 )
				);
			 }
			 
		 }

		 $this->data["$name"] = $value;
		 $this->modif = TRUE;
	}

	function Get($name) {
		return $this->data["$name"];
	}

	function __Save() {
		global $_USER;
		$table_fields = $this->database->GetTableFields($this->table); 

		// any modifications?
		if ($this->modif == TRUE) {
			// prepare names and values
			foreach ($this->data as $name => $val) {
				
				if (strtolower($name) != "returnurl") {
					$val = addslashes($val);
					$values[] = "('$name','$val'" . (in_array("base_user",$table_fields) ? ",'{$_USER[user_id]}'" : '') . ")";
				}			
			}

			// build names and values
			$values = implode(", ",$values);

			// do the nasty things
			$this->database->Query("DELETE FROM `$this->table` " . (in_array("base_user",$table_fields) ? " WHERE `base_user`='{$_USER[user_id]}'" : ''));
			$this->database->Query("INSERT INTO `$this->table` (`name`,`value`" . (in_array("base_user",$table_fields) ? ",`base_user`" : '') . ") VALUES $values");
			
		}
	}
}
?>